/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.rep;

import com.ibm.hsc.rep.RClassSchema;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.RUtils;
import java.io.Serializable;
import java.util.Vector;

public class RObjectId
implements Serializable,
Cloneable {
    private int nameSpaceId;
    private int classId;
    private Object[] key;
    private int numOfKeys;

    public RObjectId(int n, int n2) throws RException {
        this.classId = n2;
        this.nameSpaceId = n;
        this.numOfKeys = RUtils.getClassSchema(this.nameSpaceId, this.classId).getNumOfKeys();
        this.key = new Object[this.numOfKeys];
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace(System.err);
        }
        RObjectId rObjectId = (RObjectId)object;
        rObjectId.key = (Object[])this.key.clone();
        int n = 0;
        while (n < this.key.length) {
            if (this.key[n] != null) {
                if (this.key[n] instanceof Vector) {
                    rObjectId.key[n] = ((Vector)this.key[n]).clone();
                } else {
                    Class<?> clazz = this.key[n].getClass();
                    if (clazz.isArray()) {
                        rObjectId.key[n] = ((Object[])this.key[n]).clone();
                    }
                }
            }
            ++n;
        }
        return rObjectId;
    }

    public int getNameSpaceId() {
        return this.nameSpaceId;
    }

    public int getClassId() {
        return this.classId;
    }

    public int getNumOfKeys() {
        return this.numOfKeys;
    }

    public void setKeyValue(int n, Object object) {
        this.key[n] = object;
    }

    public Object getKeyValue(int n) {
        return this.key[n];
    }

    public RObject getObject() throws RException {
        RClassSchema rClassSchema = RUtils.getClassSchema(this.nameSpaceId, this.classId);
        RObject rObject = (RObject)rClassSchema.getObjHash().get(this);
        return rObject;
    }

    public boolean equals(Object object) {
        RObjectId rObjectId = (RObjectId)object;
        if (this.nameSpaceId != rObjectId.nameSpaceId) {
            return false;
        }
        if (this.classId != rObjectId.classId) {
            return false;
        }
        if (this.numOfKeys != rObjectId.numOfKeys) {
            return false;
        }
        int n = 0;
        while (n < this.numOfKeys) {
            if (!this.key[n].equals(rObjectId.key[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.nameSpaceId);
        stringBuffer.append("%");
        stringBuffer.append(this.classId);
        int n = 0;
        while (n < this.numOfKeys) {
            stringBuffer.append("%");
            stringBuffer.append(this.key[n].toString());
            ++n;
        }
        return stringBuffer.toString().hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            RClassSchema rClassSchema = RUtils.getClassSchema(this.nameSpaceId, this.classId);
            stringBuffer.append(rClassSchema.getClassName());
            stringBuffer.append(".");
            int n = 0;
            while (n < this.numOfKeys) {
                int n2 = rClassSchema.getKeyPos(n);
                String string = rClassSchema.getPropName(n2);
                stringBuffer.append(string);
                stringBuffer.append("=");
                stringBuffer.append(this.key[n]);
                if (n < this.numOfKeys - 1) {
                    stringBuffer.append(",");
                }
                ++n;
            }
            stringBuffer.append(";");
        }
        catch (RException rException) {
            rException.printStackTrace();
        }
        return stringBuffer.toString();
    }
}

